﻿Imports System
Imports System.Collections.Generic
Imports System.ComponentModel
Imports System.Data
Imports System.Drawing
Imports System.Linq
Imports System.Text
Imports System.Windows.Forms
Imports Unitronics.ComDriver
Imports Unitronics.ComDriver.Messages.DataRequest
Imports System.Runtime.Remoting.Messaging
Imports System.Reflection

Public Class Form1

    Delegate Sub UpdateGuiByPlcVersion(ByVal version As PlcVersion)
    Delegate Sub UpdateButtonsByBoolean(ByVal val As Boolean)

    Private plc As PLC
    Const LOCAL_PORT As Integer = 100
    Delegate Sub SetControlValueCallback(ByVal oControl As Control, ByVal propName As String, ByVal propValue As Object)

    Public Sub New()
        InitializeComponent()
        setButtonsEnableState(False)
    End Sub


    Private Sub setButtonsEnableState(ByVal value As Boolean)

        Connect.Enabled = Not value
        Reset.Enabled = value
        Init.Enabled = value
        plcStop.Enabled = value
        Run.Enabled = value
        Read.Enabled = value
        ReadAsynch.Enabled = value
        Write.Enabled = value

    End Sub


    Private Sub Connect_Click(ByVal sender As Object, ByVal e As EventArgs) Handles Connect.Click

        Dim listener As EthernetListener = PLCFactory.GetChannel(LOCAL_PORT)

        If (listener Is Nothing) Then
            listener = New EthernetListener(LOCAL_PORT, 3, 3000)
        End If

        AddHandler listener.OnListenerConnectionAccepted, AddressOf OnConnect
        AddHandler listener.OnListenerConnectionClosed, AddressOf OnDisconnect
        PLCFactory.GetPLC(listener)

    End Sub


    Private Sub OnConnect(ByVal oPlc As PLC)

        plc = oPlc

        Dim setGuiByBoolean As UpdateButtonsByBoolean = New UpdateButtonsByBoolean(AddressOf setButtonsEnableState)
        If (Me.InvokeRequired) Then
            Me.Invoke(setGuiByBoolean, True)
        Else
            setButtonsEnableState(True)
        End If
        Dim version As PlcVersion = plc.Version

        Dim guiUpdater As UpdateGuiByPlcVersion = New UpdateGuiByPlcVersion(AddressOf updateGuiByPlvVersion)
        If (Me.InvokeRequired) Then
            Me.Invoke(guiUpdater, version)
        Else
            guiUpdater(version)
        End If

    End Sub

    Private Sub updateGuiByPlvVersion(ByVal version As PlcVersion)

        If (version Is Nothing) Then
            txtModel.Text = ""
            txtHW.Text = ""
            txtOS.Text = ""
            txtBoot.Text = ""
            txtBinLib.Text = ""
            txtFactoryBoot.Text = ""
            txtPlcName.Text = ""
        Else
            txtModel.Text = version.OPLCModel
            txtHW.Text = version.HWVersion
            txtOS.Text = version.OSVersion
            txtBoot.Text = version.Boot
            txtBinLib.Text = version.BinLib
            txtFactoryBoot.Text = version.FactoryBoot

            Try
                Dim plcName As String = plc.PlcName
                txtPlcName.Text = plcName
            Catch
            End Try
        End If
        
    End Sub

    Private Sub OnDisconnect(ByVal ethernetListener As EthernetListener)
        Dim setGuiByBoolean As UpdateButtonsByBoolean = New UpdateButtonsByBoolean(AddressOf setButtonsEnableState)
        If (Me.InvokeRequired) Then
            Me.Invoke(setGuiByBoolean, False)
        Else
            setButtonsEnableState(False)
        End If

        Dim version As PlcVersion

        Dim guiUpdater As UpdateGuiByPlcVersion = New UpdateGuiByPlcVersion(AddressOf updateGuiByPlvVersion)
        If (Me.InvokeRequired) Then
            Me.Invoke(guiUpdater, version)
        Else
            guiUpdater(version)
        End If

        If (Not (plc Is Nothing)) Then


            ' in C#:  If (plc.PLCChannel = ethernetListener) Then

            If (Object.ReferenceEquals(plc.PLCChannel, ethernetListener)) Then
                System.Diagnostics.Debug.Print("The Ethernet Listener of out PLC object was closed. It is not longer connected")
            End If

        End If



    End Sub




    Private Sub Reset_Click(ByVal sender As Object, ByVal e As EventArgs) Handles Reset.Click
        Try
            plc.Reset()
        Catch
            System.Windows.Forms.MessageBox.Show("Could not communicate with the PLC")
        End Try
    End Sub

    Private Sub Init_Click(ByVal sender As Object, ByVal e As EventArgs) Handles Init.Click
        Try
            plc.Init()
        Catch
            System.Windows.Forms.MessageBox.Show("Could not communicate with the PLC")
        End Try
    End Sub

    Private Sub Stop_Click(ByVal sender As Object, ByVal e As EventArgs) Handles plcStop.Click
        Try
            plc.[Stop]()
        Catch
            System.Windows.Forms.MessageBox.Show("Could not communicate with the PLC")
        End Try
    End Sub

    Private Sub Run_Click(ByVal sender As Object, ByVal e As EventArgs) Handles Run.Click
        Try
            plc.Run()
        Catch
            System.Windows.Forms.MessageBox.Show("Could not communicate with the PLC")
        End Try
    End Sub

    Private Sub Disconnect_Click(ByVal sender As Object, ByVal e As EventArgs) Handles Disconnect.Click

        Dim listener As EthernetListener = PLCFactory.GetChannel(LOCAL_PORT)

        If plc IsNot Nothing Then
            plc.Disconnect()
        Else
            If listener IsNot Nothing Then
                listener.Disconnect()
            End If
        End If

        setButtonsEnableState(False)
        txtModel.Text = ""
        txtHW.Text = ""
        txtOS.Text = ""
        txtBoot.Text = ""
        txtBinLib.Text = ""
        txtFactoryBoot.Text = ""

        RemoveHandler listener.OnListenerConnectionAccepted, AddressOf OnConnect
        RemoveHandler listener.OnListenerConnectionClosed, AddressOf OnDisconnect

    End Sub

    Private Sub Read_Click(ByVal sender As Object, ByVal e As EventArgs) Handles Read.Click

        Dim rw As ReadWriteRequest() = New ReadWriteRequest(0) {}
        Dim ro As ReadOperands

        ro = New ReadOperands()

        With ro
            .OperandType = OperandTypes.MI
            .NumberOfOperands = 3
            .StartAddress = 0
        End With

        rw(0) = ro

        Try
            plc.ReadWrite(rw)

            Dim values As Object() = DirectCast((rw(0).ResponseValues), Object())

            For i As Integer = 0 To values.Length - 1
                If values(i) IsNot Nothing Then
                    Dim txtbox As TextBox = TryCast(Me.groupBox1.Controls("txtMI" & i.ToString()), TextBox)
                    txtbox.Text = CShort(values(i)).ToString()
                End If
            Next
        Catch
            System.Windows.Forms.MessageBox.Show("Could not communicate with the PLC")
        End Try
    End Sub

    Private Sub Write_Click(ByVal sender As Object, ByVal e As EventArgs) Handles Write.Click
        Dim values As Object() = New Object(2) {}
        Try
            values(0) = DirectCast(Int16.Parse(txtMI0.Text), Object)
            values(1) = DirectCast(Int16.Parse(txtMI1.Text), Object)
            values(2) = DirectCast(Int16.Parse(txtMI2.Text), Object)
        Catch
            System.Windows.Forms.MessageBox.Show("One of more of the values are not valid")
            Exit Sub
        End Try

        Dim wo As WriteOperands

        wo = New WriteOperands()

        With wo
            .OperandType = OperandTypes.MI
            .NumberOfOperands = 3
            .StartAddress = 0
            .Values = values
        End With

        Dim rw(0) As ReadWriteRequest
        rw(0) = wo

        Try
            plc.ReadWrite(rw)
        Catch
            System.Windows.Forms.MessageBox.Show("Could not communicate with the PLC")
        End Try
    End Sub

    Private Sub ReadAsynch_Click(ByVal sender As Object, ByVal e As EventArgs) Handles ReadAsynch.Click
        Dim rw As ReadWriteRequest() = New ReadWriteRequest(0) {}
        Dim ro As ReadOperands

        ro = New ReadOperands()

        With ro
            .OperandType = OperandTypes.MI
            .NumberOfOperands = 3
            .StartAddress = 0
        End With

        rw(0) = ro

        Try
            plc.ReadWrite(rw, AddressOf AsyncReply)
        Catch
            System.Windows.Forms.MessageBox.Show("Could not communicate with the PLC")
        End Try
    End Sub

    Private Sub AsyncReply(ByVal ar As IAsyncResult)
        Dim async As AsyncResult
        async = DirectCast(ar, AsyncResult)
        Dim del As ReadWriteOperandsDelegate = DirectCast(async.AsyncDelegate, ReadWriteOperandsDelegate)
        Dim rw As ReadWriteRequest() = New ReadWriteRequest(-1) {}

        Try
            del.EndInvoke(rw, ar)
        Catch
            System.Windows.Forms.MessageBox.Show("Unexpected error")
            Exit Sub
        End Try

        Dim values As Object() = DirectCast((rw(0).ResponseValues), Object())

        For i As Integer = 0 To values.Length - 1
            If values(i) IsNot Nothing Then
                Dim txtbox As TextBox = TryCast(Me.groupBox1.Controls("txtMI" & i.ToString()), TextBox)
                SetControlPropertyValue(txtbox, "Text", CShort(values(i)).ToString())

                txtbox.Text = CShort(values(i)).ToString()
            End If
        Next
    End Sub

    Private Sub SetControlPropertyValue(ByVal oControl As Control, ByVal propName As String, ByVal propValue As Object)
        If oControl.InvokeRequired Then
            Dim d As New SetControlValueCallback(AddressOf SetControlPropertyValue)
            oControl.Invoke(d, New Object() {oControl, propName, propValue})
        Else
            Dim t As Type = oControl.[GetType]()
            Dim props As PropertyInfo() = t.GetProperties()
            For Each p As PropertyInfo In props
                If p.Name.ToUpper() = propName.ToUpper() Then
                    p.SetValue(oControl, propValue, Nothing)
                End If
            Next
        End If
    End Sub


    Private Sub timer1_Tick(ByVal sender As System.Object, ByVal e As System.EventArgs) Handles timer1.Tick

        Dim listener As EthernetListener = PLCFactory.GetChannel(LOCAL_PORT)

        If listener IsNot Nothing Then
            lblStatus.Text = listener.Status.ToString()
        End If

    End Sub

    Private Sub Form1_FormClosing(ByVal sender As System.Object, ByVal e As System.Windows.Forms.FormClosingEventArgs) Handles MyBase.FormClosing

        If plc IsNot Nothing Then

            plc.Disconnect()

        Else

            Dim listener As EthernetListener = PLCFactory.GetChannel(LOCAL_PORT)

            If listener IsNot Nothing Then

                listener.Disconnect()
            End If

        End If

    End Sub

    Private Sub updateTextboxes(ByVal values() As Object)
        Dim i As Integer = 0
        While i < values.Length
            If values(i) <> Nothing Then
                Dim txtbox As TextBox = TryCast(Me.groupBox1.Controls("txtMI" + i.ToString()), TextBox)
                txtbox.Text = Convert.ToInt16(values(i)).ToString()
            End If
            System.Math.Max(System.Threading.Interlocked.Increment(i), i - 1)
        End While
    End Sub
End Class

